#ifndef _Defines_
#define _Defines_

#include "..\\K2_settings.h"

//-------------------------------------------------
// Select a board type
//-------------------------------------------------
//#define DC_SERVO
//#define DC_SERVO_REV4
//#define DC_STEP_DIR
//#define AC_SERVO_ANALOG
#define AC_SERVO_STEP_DIR

//-------------------------------------------------
// Select CoordSystem
//-------------------------------------------------
//#define DEFINE_COORD DefineCoordSystem(0, 1, 2, -1)		// 3 Axis
#define DEFINE_COORD DefineCoordSystem(0, 1, 2, 3)	// 4 Axis
//#define DEFINE_COORD DefineCoordSystem6(0, 1, 2, 3, 4, -1)	// 5 Axis

//-------------------------------------------------
// Avalible Brake-out Board Types
//-------------------------------------------------
#define TYPE_DC_STEP_DIR		1
#define TYPE_AC_SERVO_STEP_DIR	2
#define TYPE_AC_SERVO_ANALOG	3
#define TYPE_DC_SERVO           4
#define TYPE_DC_SERVO_REV4		5

//-------------------------------------------------
#define MAX_AXIS 				6
#define MAX_ACTIVE_AXIS 		5

#define JOG_LIMIT_THREAD		1
#define TOOLCHANGE_THREAD 		4
#define KNIFE_ROT_THREAD		4
#define HOMING_THREAD 			5
#define UPDATEPERSIST_THREAD	6

//-------------------------------------------------
//-- Content of persist.UserData[pdBoardDefault] must equal
//-- This value, or else persist will get Default values
#define DEFAULT_KEY			54321

//-------------------------------------------------
#define ON_SW 1
#define OFF_SW 0

#define BACKOFF_SPEED_SCALE 6
#define INDEX_SPEED_SCALE 	8

#define SLAVE_RESYNC_TOLERANCE 2000

//-------------------------------------------------
//-------------------------------------------------
//-- I/O Bits ---

//-- SPI --
#ifdef AC_SERVO_STEP_DIR 
#define pSS   29
#define pMOSI 26
#define pMISO 27
#define pSCK  28
#endif

#ifdef AC_SERVO_ANALOG
#define pSS   29
#define pMOSI 26
#define pMISO 27
#define pSCK  28
#endif

#ifdef DC_SERVO
#define pSS   8
#define pMOSI 9
#define pMISO 10
#define pSCK  11
#endif

#ifdef DC_SERVO_REV4
#define pSS   36
#define pMOSI 37
#define pMISO 38
#define pSCK  39
#endif

#ifdef DC_STEP_DIR	
#define pSS   36
#define pMOSI 37
#define pMISO 38
#define pSCK  39
#endif


// SPI Expand I/O pins
#define pIO_SCK  40
#define pIO_MISO 41
#define pIO_MOSI 42
#define pIO_SS   43

//------------------

#define pESTOP_SW 	16
#define pSTOP_SW  	17
#define pRUN_SW   	18
#define pEN_SW 	 	19

#define pInput1	 20
#define pInput2	 21
#define pInput3	 22
#define pInput4	 23

#define pEN_DRV 	 	24
#define pOutput_Enable 	25

#define pRelay1 32
#define pRelay2 33
#define pRelay3 34
#define pRelay4 35

#define pLED1 	46
#define pLED2 	47

//-- Alias I/O names --
#define pFootSw 	17

#define pSpindleFan 13
#define pSpindleFWD 34

#define pNozzleON	34
#define pTableLOCK	40

#define pSpindleStopSw 21

#define pDrive_Relay 35 //Fan Pin J11

#define pToolReleaseButton  pInput4
#define pToolReleaseOutput	pRelay4

#define pToolRelease pRelay4

#define pToolReleaseOnSW 17
#define pToolReleaseOffSW 18

//-------------------------------------------------
//-- Virtual Bits ---

//#define 	48
//#define 	49

#ifdef AC_SERVO_STEP_DIR

#define vbHomeSwX 	20
#define vbHomeSwY 	21
#define vbHomeSwZ 	22
#define vbHomeSwA 	23
#define vbHomeSwB 	54
#define vbHomeSwC 	55

#define vbIndexSwX 	56
#define vbIndexSwY 	57
#define vbIndexSwZ 	58
#define vbIndexSwA 	59
#define vbIndexSwB 	60
#define vbIndexSwC 	61

#else

#define vbHomeSwX 	50
#define vbHomeSwY 	51
#define vbHomeSwZ 	52
#define vbHomeSwA 	53
#define vbHomeSwB 	38
#define vbHomeSwC 	55

#define vbIndexSwX 	56
#define vbIndexSwY 	57
#define vbIndexSwZ 	58
#define vbIndexSwA 	59
#define vbIndexSwB 	39
#define vbIndexSwC 	61

#endif

//---------------------
//-- Status Updated Virtual bits

#define vbUpdateFromPersist	62			// Refresh Data from Persistant Data (userData)

#define vbStepResponse	63

#define vbInitialized 		1024		// Board first power-up
#define vbMachineHomed 		1025		// Machine has homed since power-up
#define vbHomeRunning 		1026		// Start Homming routine
#define vbSoftlimitEn  		1027		// Enable Softimit
#define vbToolChanging		1028		// Toolchange Cycle running
#define vbToolChangePause	1029
#define vbGCodeRunning		1030

#define vbSpindleRunning  	1032		
#define vbSpindleClamp  	1033
#define vbSpindleUnClamp  	1034

//#define 	1035
//#define  	1036
//#define  	1037
//#define  	1038
//#define  	1039

#define vbFaultX	1040
#define vbFaultY	1041
#define vbFaultZ	1042
#define vbFaultA	1043
#define vbFaultB	1044
#define vbFaultC	1045

//#define 	1046
//#define  	1047

#define vbJogX_Neg	1048
#define vbJogX_Pos	1049
#define vbJogY_Neg	1050
#define vbJogY_Pos	1051
#define vbJogZ_Neg	1052
#define vbJogZ_Pos	1053
#define vbJogA_Neg	1054
#define vbJogA_Pos	1055

//-------------------------------------------------
//-- Non-Status Updated Virtual bits

#define vbJogB_Neg	1056
#define vbJogB_Pos	1057
#define vbJogC_Neg	1058
#define vbJogC_Pos	1059

#define vbJogMode0 	1072
#define vbJogMode1 	1073

#define vbAtLimitXLo	1100
#define vbAtLimitXHi	1101
#define vbAtLimitYLo	1102
#define vbAtLimitYHi	1103
#define vbAtLimitZLo	1104
#define vbAtLimitZHi	1105
#define vbAtLimitALo	1106
#define vbAtLimitAHi	1107
#define vbAtLimitBLo	1108
#define vbAtLimitBHi	1109
#define vbAtLimitCLo	1110
#define vbAtLimitCHi	1111


#define vbExpandIn0		1120
#define vbExpandIn1		1121
#define vbExpandIn2		1122
#define vbExpandIn3		1123
#define vbExpandIn4		1124
#define vbExpandIn5		1125
#define vbExpandIn6		1126
#define vbExpandIn7		1127

#define vbExpandOut0	1136
#define vbExpandOut1	1137
#define vbExpandOut2	1138
#define vbExpandOut3	1139
#define vbExpandOut4	1140
#define vbExpandOut5	1141
#define vbExpandOut6	1142
#define vbExpandOut7	1143

//-------------------------------------------------
//-- Non-Status Updated Virtual bits (use as Globals for Threads)
#define vbHomeStarted 		1500
#define vbAbortHome 		1501

#define vbDriveEnable 		1502

#define vbThread4Started 	1510
#define vbThread5Started 	1511
#define vbThread6Started 	1512

#define vbToolChangeStarted 1513
#define vbAbortToolChange 	1514

//-------------------------------------------------
//-------------------------------------------------
//-- Persistant Data
//-------------------------------------------------

//--- 32-Bit Int Values
#define pdBoardDefault		7
#define pdControlType		8
#define pdFirmwareVersion	9

//--- BIT wise flags 
#define pdRevDir		10
#define pdRevHome		11
#define pdHomeActiveLow 12
#define pdHomingMode	13
#define pdHomeIndexOn	14
#define pdHomeToOffset	15 

//--- 32-Bit Int Values
#define pdCurrentTool	30
#define pdNewTool		31

#define pdSpindleRPM	35

#define pdJogSpeed0		40
#define pdJogSpeed1		41
#define pdJogSpeed2		42

#define pdSlaveATo		45
#define pdSlaveBTo		46

#define pdHomeSpeedX	50	
#define pdHomeSpeedY	51
#define pdHomeSpeedZ	52
#define pdHomeSpeedA	53
#define pdHomeSpeedB	54
#define pdHomeSpeedC	55

#define PC_COMM_PERSIST	100  //100-108 Used for PC_COMM_PERSIST

//--- Double Values (64-Bit, 2 locations)
#define pdStepPerInX	120
#define pdStepPerInY	122
#define pdStepPerInZ	124
#define pdStepPerInA	126
#define pdStepPerInB	128
#define pdStepPerInC	130

#define pdSoftLimitXMin	132
#define pdSoftLimitXMax	134
#define pdSoftLimitYMin	136
#define pdSoftLimitYMax	138
#define pdSoftLimitZMin	140
#define pdSoftLimitZMax	142
#define pdSoftLimitAMin	144
#define pdSoftLimitAMax	146
#define pdSoftLimitBMin	148
#define pdSoftLimitBMax	150
#define pdSoftLimitCMin	152
#define pdSoftLimitCMax	154

#define pdHomeOffsetX	160
#define pdHomeOffsetY	162
#define pdHomeOffsetZ	164
#define pdHomeOffsetA	166
#define pdHomeOffsetB	168
#define pdHomeOffsetC	170


//-------------------------------------------------
//-------------------------------------------------

#define X 0
#define Y 1
#define Z 2
#define A 3
#define B 4
#define C 5


#define LIMIT_SAFE 		0
#define LIMIT_ZONE_LO 	-1
#define LIMIT_LO 		-2
#define LIMIT_ZONE_HI 	1
#define LIMIT_HI 		2

//-------------------------------------------------
//-- Globals Variables --
//-------------------------------------------------
int i;

int revDirSav;

const int pwmCh[6] = { 1, 3, 5, 7, 9, 11};
int revDir[6];			// Reverse Jog Direction?
int revHome[6];			// Reverse Home direction?
int homeActiveLow[6];	// Switch normally close or open
int homeIndexOn[6];		// Home using Index Pulse of encoder
int homeSpeed[6];		// Set Speed of Homing routine
int fHomeDone[6];		// Flag use to indcate homing complete for each axis
int homeAxisEn[6];		// Home active
int homeMode;			

double hmIndexPos[6];

int isMoving[6];

int jogSpeed[3];
int jogFlagState, jogFlagStateSav;	

int currentSpeed;

int spiData;

int fToolChangeDone;

int atLimit[MAX_AXIS];

double homeOffset[MAX_AXIS];
double stepsPerIn[MAX_AXIS];

double softLimitLo[MAX_AXIS];
double softLimitHi[MAX_AXIS];
double savLastPos[MAX_AXIS];
double delta[MAX_AXIS];

int spiOutput;

//-------------------------------------------------
typedef void USERCALLBACK(void);
extern USERCALLBACK *UserCallBack;

#endif
